/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class YamlFoldParser
implements FoldParser {
    private static boolean isSpaces(Token t2) {
        String lexeme = t2.getLexeme();
        return lexeme.trim().isEmpty();
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Stack<Integer> indentStack = new Stack<Integer>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        int lastOffset = 0;
        try {
            for (int line = 0; line < lineCount; ++line) {
                int outer;
                Token t2;
                Token startLine = t2 = textArea.getTokenListForLine(line);
                int offset = t2.getOffset();
                int indent = 0;
                while (t2 != null && t2.isPaintable() && YamlFoldParser.isSpaces(t2)) {
                    indent += t2.length();
                    t2 = t2.getNextToken();
                }
                if (t2 != null && t2.isPaintable() && t2.isSingleChar('-')) {
                    ++indent;
                    t2 = t2.getNextToken();
                }
                while (!indentStack.empty() && (outer = ((Integer)indentStack.peek()).intValue()) >= indent && currentFold != null) {
                    currentFold.setEndOffset(lastOffset);
                    Fold parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine()) {
                        YamlFoldParser.removeFold(currentFold, folds);
                    }
                    currentFold = parentFold;
                    indentStack.pop();
                }
                while (t2 != null && t2.isPaintable()) {
                    offset = t2.getOffset();
                    t2 = t2.getNextToken();
                }
                lastOffset = offset;
                if (currentFold == null) {
                    currentFold = new Fold(0, textArea, startLine.getOffset());
                    folds.add(currentFold);
                } else {
                    currentFold = currentFold.createChild(0, startLine.getOffset());
                }
                indentStack.push(indent);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static void removeFold(Fold fold, List<Fold> folds) {
        if (!fold.removeFromParent()) {
            folds.remove(folds.size() - 1);
        }
    }
}

